-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.looper = 4
    self.p0 = Citadels.GetPlayer(0)
	  
    if not self.loaded then
      self.active = true
      self.timer = self.looper
    end
    
    self.stone:LinkToTarget("questStone")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
  
    if self.timer <= 0 then
	    CheckForPlayer(self)
      self.timer = self.looper
    end
  end   
end

function OnBeforeDeath(self)
  self.stone:TriggerAllTargets()
end

function CheckForPlayer(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 3000, '*')
  
  if p0units > 1 then
    self.p0:AddQuest('D08_STONE', 'side') -- Add correct quest
    self.active = false
  end  
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("stone")
end
